<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Oficina de Mantenimiento y Servicios Generales de la Universidad Nacional de San Martin - UNSM">
    <meta name="keywords" content="UNSM, Mantenimiento, Servicios Generales, Universidad San Martin">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <title>Mantenimiento y Servicios Generales - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Servicios Generales -->
    <link rel="stylesheet" href="css/styleServiGe.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en Facebook" aria-label="Pagina oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Siguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Siguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Telefono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la pagina principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martin" width="auto" height="70">
                </a>
            </div>

            <!-- Boton Hamburguesa para movil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menu de navegacion" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegacion principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../../../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menu Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Mision y Vision</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Academico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../../../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menu Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Academico</a></li>
                                <li><a href="../../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigacion</a></li>
                                <li><a href="../../../oficinas/secretaria general/indexSecreGene.php">Secretaria General</a></li>
                                <li><a href="../../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicacion e Imagen Institucional</a></li>
                                <li><a href="../../../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperacion y Relaciones Internacionales</a></li>
                                <li><a href="../../../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Organo de Control Institucional</a></li>
                                <li><a href="../../../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../../../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoria Juridica</a></li>
                                <li><a href="../../../oficinas/Grados y Titulos/indexGrados.php">Grados y Titulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Academicas</li>
                                <li><a href="../OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admision</a></li>
                                <li><a href="../ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Academicos</a></li>
                                <li><a href="../Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Insercion Laboral</a></li>
                                <li><a href="../TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologias de la Informacion</a></li>
                                <li><a href="../INCUBADORA DE EMPRESAS/indexIncu.php">Incubadora de Empresas</a></li>
                                <li><a href="../FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="../COMITE ELECTORAL UNIVERSITARIO/indexComite.php">Comite Electoral Universitario</a></li>
                                <li><a href="../INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php">Innovacion y Transferencia Tecnologica</a></li>
                                <li><a href="../PRODUCCION DE BIENES Y SERVICIOS/indexProdu.php">Produccion de Bienes y Servicios</a></li>
                                <li><a href="../RESPONSABILIDAD SOCIAL UNIVERSITARIA/indexRespon.php">Responsabilidad Social Universitaria</a></li>
                                <li><a href="indexServiGe.php">Servicios Generales</a></li>
                                <li><a href="../../../#bienestar">Bienestar Universitario</a></li>
                                <li><a href="../../../#defensoria">Defensoria Universitaria</a></li>
                                <li><a href="../../../#calidad">Gestion de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">ADMISION</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menu Facultades">
                            <li class="has-submenu">
                                <a href="../../../#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../../#agronomia">Agronomia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../../#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../../#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingenieria Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Agroindustrial">
                                    <li><a href="../../../#ing-agroindustrial">Ingenieria Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingenieria Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Civil y Arquitectura">
                                    <li><a href="../../../#arquitectura">Arquitectura</a></li>
                                    <li><a href="../../../#ingenieria-civil-carrera">Ingenieria Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingenieria de Sistemas e Informatica</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria de Sistemas">
                                    <li><a href="../../../#ing-sistemas">Ingenieria de Sistemas e Informatica</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ecologia" aria-haspopup="true" aria-expanded="false">Ecologia</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecologia">
                                    <li><a href="../../../#ing-ambiental">Ingenieria Ambiental</a></li>
                                    <li><a href="../../../#ing-sanitaria">Ingenieria Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Politicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../../../#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../../../#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../../../#enfermeria">Enfermeria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Economicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Economicas">
                                    <li><a href="../../../#administracion">Administracion</a></li>
                                    <li><a href="../../../#contabilidad">Contabilidad</a></li>
                                    <li><a href="../../../#economia">Economia</a></li>
                                    <li><a href="../../../#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#educacion" aria-haspopup="true" aria-expanded="false">Educacion y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educacion">
                                    <li><a href="../../../#educacion-inicial">Educacion Inicial</a></li>
                                    <li><a href="../../../#educacion-primaria">Educacion Primaria</a></li>
                                    <li><a href="../../../#educacion-secundaria">Educacion Secundaria</a></li>
                                    <li><a href="../../../#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../../../#psicologia">
                                            Psicologia
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menu Transparencia">
                            <li><a href="#licenciamiento">Licenciamiento</a></li>
                            <li><a href="#institucional">Institucional Ley 30220</a></li>
                            <li><a href="#estandar">Estandar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Peru">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Peru">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Mantenimiento y Servicios Generales -->
    <section class="comite-banner">
        <div class="banner-container">
            <h1>MANTENIMIENTO Y SERVICIOS GENERALES</h1>
            <div class="banner-contact">
                <p><strong>Local Central, Jr. Maynas N° 177, Tarapoto, Peru</strong></p>
                <p>osgm@unsm.edu.pe</p>
            </div>
        </div>
    </section>

    <!-- Contenido Principal -->
    <main class="comite-main">
        <div class="comite-container">
            <!-- Sidebar con tabs -->
            <aside class="comite-sidebar">
                <nav class="tabs-menu">
                    <button class="tab-button active" data-tab="funciones">
                        <span class="tab-icon">&#9881;</span>
                        <span class="tab-text">FUNCIONES</span>
                    </button>
                    <button class="tab-button" data-tab="mision">
                        <span class="tab-icon">&#127919;</span>
                        <span class="tab-text">MISION</span>
                    </button>
                    <button class="tab-button" data-tab="vision">
                        <span class="tab-icon">&#128065;</span>
                        <span class="tab-text">VISION</span>
                    </button>
                    <button class="tab-button" data-tab="personal">
                        <span class="tab-icon">&#128100;</span>
                        <span class="tab-text">PERSONAL</span>
                    </button>
                    <button class="tab-button" data-tab="documentos">
                        <span class="tab-icon">&#128195;</span>
                        <span class="tab-text">DOCUMENTOS</span>
                    </button>
                    <button class="tab-button" data-tab="organigrama">
                        <span class="tab-icon">&#128202;</span>
                        <span class="tab-text">ORGANIGRAMA</span>
                    </button>
                </nav>
            </aside>

            <!-- Contenido principal -->
            <div class="comite-content">
                <!-- Tab de Funciones -->
                <div class="tab-content active" id="funciones">
                    <div class="content-wrapper">
                        <h2>FUNCIONES</h2>

                        <ul class="funciones-list">
                            <li>Elaborar el diagnostico de la situacion de los bienes muebles e inmuebles y de los vehiculos motorizados asignados a las Facultades, Instituto, Centros de Investigacion y organos de la Administracion Central y proponer la ejecucion de programas de servicios generales de mantenimiento y transportes.</li>

                            <li>Normar, coordinar, asesorar y apoyar a las unidades operativas de la Oficina, para una adecuada cobertura de los servicios generales y mantenimiento y los servicios de transportes.</li>

                            <li>Formular y proponer a la Alta Direccion de la UNSM-T la politica de la Oficina de Mantenimiento y Servicios Generales, asi como los planes operativos.</li>

                            <li>Formular y proponer a las Instancias respectivas el presupuesto de la Oficina de Mantenimiento y Servicios Generales asi como supervisar su ejecucion.</li>

                            <li>Supervisar en forma permanente la calidad de los servicios brindados por la Oficina de Mantenimiento y Servicios Generales, asi como los servicios brindados por terceros en los ambientes de la UNSM-T.</li>

                            <li>Planificar, ejecutar y controlar los servicios y operaciones de mantenimiento de las instalaciones de la UNSM-T.</li>

                            <li>Elaborar un manual de seguridad e higiene industrial que regule las funciones de control y preservacion de los bienes, equipos y bienes inmuebles de la UNSM-T.</li>

                            <li>Coordinar con el Sistema Nacional de Defensa Civil las acciones de prevencion de desastres naturales.</li>

                            <li>Mantener en condiciones de operatividad los vehiculos, maquinaria y equipo utilizados en las actividades academicas y administrativas de la UNSM-T.</li>

                            <li>Otras funciones que le asigne la Alta Direccion.</li>
                        </ul>
                    </div>

                    <!-- Widget de Ultimas Noticias -->
                    <aside class="noticias-widget">
                        <h3>Ultimas Noticias</h3>
                        <div class="noticias-container">
                            <p class="no-events">No hay nuevos eventos.</p>
                            <div class="calendario-actions">
                                <a href="#" class="btn-calendar">Ver Calendario &#9656;</a>
                            </div>
                        </div>
                    </aside>
                </div>

                <!-- Tab de Mision -->
                <div class="tab-content" id="mision">
                    <div class="content-wrapper">
                        <h2>MISION</h2>
                        <p>Somos la unidad encargada de planificar, organizar, dirigir y controlar las actividades de mantenimiento, conservacion y servicios generales de la infraestructura fisica, equipos, maquinarias y vehiculos de la Universidad Nacional de San Martin, garantizando ambientes seguros, funcionales y adecuados para el desarrollo de las actividades academicas y administrativas.</p>
                    </div>
                </div>

                <!-- Tab de Vision -->
                <div class="tab-content" id="vision">
                    <div class="content-wrapper">
                        <h2>VISION</h2>
                        <p>Ser una oficina reconocida por su eficiencia y calidad en la prestacion de servicios de mantenimiento y servicios generales, contribuyendo al desarrollo institucional mediante la conservacion optima de la infraestructura y recursos de la universidad, con un equipo comprometido y orientado a la mejora continua.</p>
                    </div>
                </div>

                <!-- Tab de Personal -->
                <div class="tab-content" id="personal">
                    <div class="content-wrapper">
                        <h2>PERSONAL</h2>
                        <p>La Oficina de Mantenimiento y Servicios Generales de la UNSM cuenta con un equipo de profesionales y tecnicos especializados en mantenimiento de infraestructura, servicios generales y transporte.</p>
                        <p>Informacion sobre el personal de la oficina estara disponible proximamente.</p>
                    </div>
                </div>

                <!-- Tab de Documentos -->
                <div class="tab-content" id="documentos">
                    <div class="content-wrapper">
                        <h2>DOCUMENTOS</h2>
                        <p>En esta seccion encontrara los documentos oficiales, reglamentos y formularios relacionados con la gestion de mantenimiento y servicios generales:</p>
                        <ul class="funciones-list">
                            <li><strong>Manual de Organizacion y Funciones:</strong> Documento que establece las funciones y responsabilidades de la oficina</li>
                            <li><strong>Plan de Mantenimiento:</strong> Programa anual de mantenimiento preventivo y correctivo</li>
                            <li><strong>Reglamento de Uso de Vehiculos:</strong> Normas para el uso de vehiculos institucionales</li>
                            <li><strong>Formatos y Solicitudes:</strong> Documentos para tramites relacionados con servicios generales</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Organigrama -->
                <div class="tab-content" id="organigrama">
                    <div class="content-wrapper">
                        <h2>ORGANIGRAMA</h2>
                        <p>El organigrama de la Oficina de Mantenimiento y Servicios Generales estara disponible proximamente.</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autonomo y de caracter estatal, comprometido con la formacion de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martin - Peru</p>
                    <p>Central Telefonica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rapidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../#admision">Admision</a></li>
                    <li><a href="../../../#facultades">Facultades</a></li>
                    <li><a href="../../../#posgrado">Posgrado</a></li>
                    <li><a href="../../../#investigacion">Investigacion</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="#campus-virtual">Campus Virtual</a></li>
                    <li><a href="#repositorio">Repositorio Institucional</a></li>
                    <li><a href="#transparencia">Portal de Transparencia</a></li>
                    <li><a href="#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <!-- Plugin de Facebook -->
                <?php include 'plugin/meta.html'; ?>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martin. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Siguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="../../../js/script.js"></script>
    <script src="js/serviciosGenerales.js"></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
